% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{isAvailable}
\alias{isAvailable}
\title{Is a required package available?}
\usage{
isAvailable(pkg, type = c("annotation", "software", "data"))
}
\arguments{
\item{pkg}{Character vector of length 1.  A valid name of an existing R
package.}

\item{type}{Character vector of length 1.  What type of package is this?
Choose one out of 'annotation', 'software', or 'data' package.}
}
\value{
None. See details.
}
\description{
Convenience function for checking and installing required packages.
}
\details{
Checks whether a required package is available in the library.  If yes, the
package is loaded via \code{\link{requireNamespace}}.  If not, the package is
optionally installed via \code{\link{install}} and,
subsequently, loaded via \code{\link{requireNamespace}}.
}
\examples{

    \donttest{
        isAvailable("EnrichmentBrowser", type="software")
    }     

}
\seealso{
\code{require}, \code{install}
}
\author{
Ludwig Geistlinger <Ludwig.Geistlinger@sph.cuny.edu>
}
