% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_encircle.R
\name{geom_encircle}
\alias{geom_encircle}
\title{Automatically enclose points in a polygon}
\usage{
geom_encircle(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}. 
If specified and \code{inherit.aes = TRUE} (the default), it is combined with 
the default mapping at the top level of the plot.}

\item{data}{The data to be displayed in this layer. If \code{NULL}, the default,
the data is inherited from the plot data as specified in the call to 
\code{\link[ggplot2]{ggplot}}.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a call
to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning.
If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{Logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them.}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like 
\code{colour = "red"} or \code{size = 3}. They may also be parameters to the
paired geom/stat. Additional parameters include:
\describe{
  \item{s_shape}{Controls the shape of the spline (default = 0.5).}
  \item{s_open}{Logical indicating whether the spline should be open (default = FALSE).}
  \item{expand}{Amount to expand the encircling polygon outward (default = 0.05).}
  \item{spread}{Spread factor for single or double point sets (default = 0.1).}
}}
}
\value{
A ggplot2 layer that can be added to a plot.
}
\description{
Creates a smooth encircling polygon around a set of points using convex hull
calculation and xspline smoothing. Useful for highlighting groups of points
in scatter plots.
}
\examples{
\dontrun{
library(ggplot2)

d <- data.frame(x=c(1,1,2),y=c(1,2,2)*100)

gg <- ggplot(d,aes(x,y))
gg <- gg + scale_x_continuous(expand=c(0.5,1))
gg <- gg + scale_y_continuous(expand=c(0.5,1))

gg + geom_encircle(s_shape=1, expand=0) + geom_point()

gg + geom_encircle(s_shape=1, expand=0.1, colour="red") + geom_point()

gg + geom_encircle(s_shape=0.5, expand=0.1, colour="purple") + geom_point()

gg + geom_encircle(data=subset(d, x==1), colour="blue", spread=0.02) +
  geom_point()

gg + geom_encircle(data=subset(d, x==2), colour="cyan", spread=0.04) +
  geom_point()

gg <- ggplot(mpg, aes(displ, hwy))
gg + geom_encircle(data=subset(mpg, hwy>40)) + geom_point()
gg + geom_encircle(aes(group=manufacturer)) + geom_point()
gg + geom_encircle(aes(group=manufacturer,fill=manufacturer),alpha=0.4)+
       geom_point()
gg + geom_encircle(aes(group=manufacturer,colour=manufacturer))+
       geom_point()

ss <- subset(mpg,hwy>31 & displ<2)

gg + geom_encircle(data=ss, colour="blue", s_shape=0.9, expand=0.07) +
  geom_point() + geom_point(data=ss, colour="blue")
}
}
\author{
Jared Andrews, heavily based on ggalt code from Ben Bolker
  (\url{https://github.com/hrbrmstr/ggalt/blob/master/R/geom_encircle.r})
}
