% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_model.R
\name{ensemble_model}
\alias{ensemble_model}
\title{Trainging stacking ensemble model for Methylation Correlation Block}
\usage{
ensemble_model(single_res,training_set,Surv_training,testing_set,
Surv_testing,ensemble_type)
}
\arguments{
\item{single_res}{Methylation Correlation Block information returned by the IndentifyMCB function.}

\item{training_set}{methylation matrix used for training the model in the analysis.}

\item{Surv_training}{Survival function contain the survival information for training.}

\item{testing_set}{methylation matrix used for testing the model in the analysis.}

\item{Surv_testing}{Survival function contain the survival information for testing.}

\item{ensemble_type}{Secondary model use for ensemble, one of "Cox", "C-index" and "feature weighted linear regression".
"feature weighted linear regression" only uses two meta-features namely kurtosis and S.D.}
}
\value{
Object of class \code{list} with elements (XXX repesents the model you choose):
 \tabular{ll}{
   \code{cox} \tab Model object for the cox model at first level. \cr
   \code{svm} \tab Model object for the svm model at first level. \cr
   \code{enet} \tab Model object for the enet model at first level. \cr
   \code{mboost} \tab Model object for the mboost model at first level. \cr
   \code{stacking} \tab Model object for the stacking model. \cr
 }
}
\description{
Method for training a stacking ensemble model for Methylation Correlation Block.
}
\examples{
#import datasets
library(survival)
data(demo_survival_data)
datamatrix<-create_demo()
data(demo_MCBinformation)
#select MCB with at least 3 CpGs.
demo_MCBinformation<-demo_MCBinformation[demo_MCBinformation[,"CpGs_num"]>2,]
trainingset<-colnames(datamatrix) \%in\% sample(colnames(datamatrix),0.6*length(colnames(datamatrix)))
select_single_one=1
em<-ensemble_model(t(demo_MCBinformation[select_single_one,]),
    training_set=datamatrix[,trainingset],
    Surv_training=demo_survival_data[trainingset])


}
\references{
Xin Yu et al. 2019 Predicting disease progression in lung adenocarcinoma patients based on methylation correlated blocks using ensemble machine learning classifiers (under review)
}
\author{
Xin Yu
}
\keyword{ensemble}
\keyword{methylation}
\keyword{stacking}
