% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_bootstrap_plots_for_transcriptome.r
\name{generate_bootstrap_plots_for_transcriptome}
\alias{generate_bootstrap_plots_for_transcriptome}
\title{Generate bootstrap plots}
\usage{
generate_bootstrap_plots_for_transcriptome(
  sct_data,
  tt,
  bg = NULL,
  thresh = 250,
  annotLevel = 1,
  reps = 100,
  full_results = NA,
  listFileName = "",
  showGNameThresh = 25,
  ttSpecies = NULL,
  sctSpecies = NULL,
  output_species = NULL,
  sortBy = "t",
  sig_only = TRUE,
  sig_col = "q",
  sig_thresh = 0.05,
  celltype_col = "CellType",
  plot_types = c("bootstrap", "bootstrap_distributions", "log_bootstrap_distributions"),
  save_dir = file.path(tempdir(), "BootstrapPlots"),
  method = "homologene",
  verbose = TRUE
)
}
\arguments{
\item{sct_data}{List generated using \link[EWCE]{generate_celltype_data}.}

\item{tt}{Differential expression table.
Can be output of \link[limma]{topTable} function.
Minimum requirement is that one column stores a metric of
increased/decreased expression (i.e. log fold change, t-statistic for
differential expression etc) and another contains gene symbols.}

\item{bg}{List of gene symbols containing the background gene list
(including hit genes). If \code{bg=NULL},
 an appropriate gene background will be created automatically.}

\item{thresh}{The number of up- and down- regulated genes to be included in
each analysis (Default: 250).}

\item{annotLevel}{An integer indicating which level of \code{sct_data} to
analyse (\emph{Default: 1}).}

\item{reps}{Number of random gene lists to generate (\emph{Default: 100},
but should be >=10,000 for publication-quality results).}

\item{full_results}{The full output of
\link[EWCE]{ewce_expression_data} for the same gene list.}

\item{listFileName}{String used as the root for files saved using
this function.}

\item{showGNameThresh}{Integer. If a gene has over X percent of it's
expression proportion in a cell type, then list the gene name.}

\item{ttSpecies}{The species the differential expression table
was generated from.}

\item{sctSpecies}{Species that \code{sct_data} is currently formatted as
(no longer limited to just "mouse" and "human").
See \link[EWCE]{list_species} for all available species.}

\item{output_species}{Species to convert \code{sct_data} and \code{hits} to
(Default: "human").
See \link[EWCE]{list_species} for all available species.}

\item{sortBy}{Column name of metric in \code{tt}
which should be used to sort up- from down- regulated genes (Default: "t").}

\item{sig_only}{Should plots only be generated for cells which have
significant changes?}

\item{sig_col}{Column name in \code{tt} that contains the
significance values.}

\item{sig_thresh}{Threshold by which to filter \code{tt} by \code{sig_col}.}

\item{celltype_col}{Column within \code{tt} that contains celltype names.}

\item{plot_types}{Plot types to generate.}

\item{save_dir}{Directory where the BootstrapPlots folder should be saved,
default is a temp directory.}

\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{verbose}{Print messages.}
}
\value{
Saves a set of PDF files containing graphs. 
Then returns a nested list with each \code{plot} and
 the \code{path} where it was saved to.
Files start with one of the following:
\itemize{
  \item \code{qqplot_noText}: sorts the gene list according to how enriched
  it is in the relevant cell type. Plots the value in the target list against
  the mean value in the bootstrapped lists.
  \item \code{qqplot_wtGSym}: as above but labels the gene symbols for the
  highest expressed genes.
  \item \code{bootDists}: rather than just showing the mean of the
  bootstrapped lists, a boxplot shows the distribution of values
  \item \code{bootDists_LOG}: shows the bootstrapped distributions with the
  y-axis shown on a log scale
}
}
\description{
Takes a gene list and a single cell type transcriptome dataset 
and generates plots which show how the expression of the genes in
 the list compares to those in randomly generated gene lists.
}
\examples{
## Load the single cell data
ctd <- ewceData::ctd()

## Set the parameters for the analysis
## Use 3 bootstrap lists for speed, for publishable analysis use >10,000
reps <- 3
annotLevel <- 1 # <- Use cell level annotations (i.e. Interneurons)
## Use 5 up/down regulated genes (thresh) for speed, default is 250
thresh <- 5

## Load the top table
tt_alzh <- ewceData::tt_alzh()

## See ?example_transcriptome_results for full code to produce tt_results
tt_results <- EWCE::example_transcriptome_results()

## Bootstrap significance test,
## no control for transcript length or GC content
savePath <- EWCE::generate_bootstrap_plots_for_transcriptome(
    sct_data = ctd,
    tt = tt_alzh,
    thresh = thresh,
    annotLevel = 1,
    full_results = tt_results,
    listFileName = "examples",
    reps = reps,
    ttSpecies = "human",
    sctSpecies = "mouse", 
    # Only do one plot type for demo purposes
    plot_types = "bootstrap" 
) 
}
