% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{integrative_heatmap}
\alias{integrative_heatmap}
\title{Plot heatmaps based on simple integrative clustering of multiple matrices}
\usage{
integrative_heatmap(
  X_raw,
  result,
  gff3_fn,
  exclude_genes,
  col_pal_gene = col_yarrr_info2,
  col_cn = colorRamp2(c(0.5, 1, 1.5), c(muted("blue"), "white", muted("red"))),
  col_y = colorRamp2(c(0.5, 1, 2), c(muted("blue"), "white", muted("red"))),
  col_z = colorRamp2(c(-4, 0, 4), c(muted("blue"), "white", muted("red"))),
  col_x_scaled = "auto",
  col_vl = "auto",
  baseline = 1,
  matrices_to_plot = "all",
  matrices_integ_cluster = "all",
  total_aligned_base__host_and_virus = NULL,
  return_data_matrices = FALSE
)
}
\arguments{
\item{X_raw}{Raw depth matrix}

\item{result}{Run result}

\item{gff3_fn}{gene annotation file name}

\item{exclude_genes}{name of genes to exclude from the annotation track (Default : NULL)}

\item{col_pal_gene}{color palette for gene colors}

\item{col_cn}{Color scheme for copy number heatmap (Default :\code{colorRamp2(c(0.5,1,1.5),c(muted("blue"),"white",muted("red")))})}

\item{col_y}{Color scheme for normalized read depth(Y) heatmap (Default : \code{colorRamp2(c(0.5,1,2),c(muted("blue"),"white",muted("red")))})}

\item{col_z}{Color scheme for Z-score heatmap (Default : \code{colorRamp2(c(-4,0,4),c(muted("blue"),"white",muted("red")))})}

\item{col_x_scaled}{Color scheme for scaled raw depth(X) heatmap (Default : \code{"auto"})}

\item{col_vl}{Color scheme for positional viral load heatmap (Default : \code{"auto"})}

\item{baseline}{Vector of state numbers to use as baseline for each sample. If it is single integer, then the given state number is used for all samples. (Default : \code{1})}

\item{matrices_to_plot}{Names and orders of the matrices to show as heatmap. Any permutation of \code{c("CN","Y","Z","X_Scaled","Viral_Load")} of any length is allowed. The vertical orders of stacked heatmaps follows the order of this vector. If set to \code{"all"}, \code{c("CN","Y","Z","X_Scaled","Viral_Load")} is used. (Default : \code{"all"})}

\item{matrices_integ_cluster}{Names of the matrices to be used for integrative clustering for column orders. Any combination of \code{c("CN","Y","Z","X_Scaled","Viral_Load")} of length > 1 is allowed. If the length is less then 2, then it is ignored and the first matrix specified in \code{matrices_to_plot} argument is used for column ordering. The vertical orders of stacked heatmaps follows the order of this vector. If set to \code{"all"}, \code{c("CN","Y","Z","X_Scaled","Viral_Load")} is used. (Default : \code{"all"})}

\item{total_aligned_base__host_and_virus}{Total aligned bases for each sample(i.e. from picard,gatk,qualimap). Used to calculate positional load of viral DNA. Makes sense if regions in host genome are also included in the target panel. Ignored if set to NULL. (Default : NULL)}

\item{return_data_matrices}{boolean whether to return the data matrices used. (Default : \code{FALSE})}
}
\value{
A ComplexHeatmap Heatmap List object vertically stacked
}
\description{
Plot heatmaps based on simple integrative clustering of multiple matrices
}
\examples{


# gff3 gene model file
package_name <- "ELViS"
gff3_fn <- system.file("extdata","HPV16REF_PaVE.gff",package = package_name)

# loading precalculated depth matrix
data(mtrx_samtools_reticulate)

# threshold
th <- 50

# filtered matrix
base_resol_depth <- filt_samples(mtrx_samtools_reticulate,th=th,smry_fun=max)

# viral load data
data(total_aligned_base__host_and_virus)
viral_load <- (10^6)*(apply(base_resol_depth,2,\(x) sum(x)) )/total_aligned_base__host_and_virus

# load ELViS run result
data(ELViS_toy_run_result)
result <- ELViS_toy_run_result

# genes to exclude from plotting
exclude_genes <- c("E6*","E1^E4","E8^E2")

# heatmap based on integrative clustering
integ_ht_result <- integrative_heatmap(
  X_raw = base_resol_depth,
  result = result,
  gff3_fn = gff3_fn,
  exclude_genes = exclude_genes,
  baseline=1,
  total_aligned_base__host_and_virus = total_aligned_base__host_and_virus
  )

integ_ht_result



}
