% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Process_Bam.R
\name{get_depth_matrix}
\alias{get_depth_matrix}
\title{Generate a read depth matrix of positions x samples from input BAM files list}
\usage{
get_depth_matrix(
  bam_files,
  mode = "samtools_reticulate",
  coord_or_target_virus_name,
  is_virus = TRUE,
  N_cores = detectCores(),
  min_mapq = 30,
  min_base_quality = 0,
  max_depth = 1e+05,
  modules = NULL,
  envs = NULL,
  tmpdir = tempdir(),
  samtools = NULL,
  condaenv = "env_samtools",
  condaenv_samtools_version = "auto"
)
}
\arguments{
\item{bam_files}{Vector containing bam file names in character}

\item{mode}{Mode of read depth calculation. Either of \code{c("samtools_reticulate","samtools_custom","Rsamtools")} are acceptable. If run on Windows OS, it will coerced to \code{"Rsamtools"} (Default : \code{"samtools_reticulate"})}

\item{coord_or_target_virus_name}{The name of the target virus. This should be equal to the name of the sequence in the FASTA file reads are aligned to.}

\item{is_virus}{logical indicating if the coord_or_target_virus_name is for viral genome(TRUE) or non-viral genome(FALSE) (default : TRUE)}

\item{N_cores}{Number of cores to use for parallel processing (Default : min(10,available cores))}

\item{min_mapq}{Minimum MAPQ. (Default : 30)}

\item{min_base_quality}{Minimum basecall quality score (Default : 0)}

\item{max_depth}{(Rsamtools) Maximum read depth. (Default : 1e5)}

\item{modules}{(samtools) Environment modulefile name. (Default : NULL)}

\item{envs}{(samtools) Environmental variables for samtools. (Default : NULL)}

\item{tmpdir}{(samtools) Temporary file directory (Default : \code{tempdir()})}

\item{samtools}{(samtools) Absolute path to samtools executable (Default : NULL)}

\item{condaenv}{(samtools_reticulate) Name of the conda environment in which samtools are installed. If no environment with this name is available, one will be created. (Default : \code{"env_samtools"})}

\item{condaenv_samtools_version}{(samtools_reticulate) The version of samtools to install in the conda environment using basilisk. If set to "auto", the latest available version of samtools will be installed.  (Default : "auto")}
}
\value{
a matrix of positions x samples containing base-resolution raw read depth
}
\description{
Generate a read depth matrix of positions x samples from input BAM files list
}
\examples{

package_name <- "ELViS"

# The name of the target virus
# in the reference sequence FASTA file used for alignment.
# Can be check by samtools view -H input.bam
target_virus_name <- "gi|333031|lcl|HPV16REF.1|"

# get bam file pathes
ext_path <- system.file("extdata",package = package_name)
bam_files <- list.files(ext_path,full.names = TRUE,pattern = "bam$")

# number of threads to use
N_cores <- 1L

# get read depth matrix
tmpdir <- tempdir()

mtrx_samtools_reticulate <-
 get_depth_matrix(
  bam_files = bam_files,coord_or_target_virus_name = target_virus_name,is_virus = TRUE
 ,mode = "samtools_reticulate"
 ,N_cores = N_cores
 ,min_mapq = 30
 ,tmpdir=tempdir()
 ,condaenv = "env_samtools"
 )


}
