% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{heatmapPairs}
\alias{heatmapPairs}
\title{Heatmap of pairs gene and probes anti-correlated}
\usage{
heatmapPairs(
  data,
  group.col,
  group1,
  group2,
  pairs,
  subset = FALSE,
  cluster.within.groups = TRUE,
  plot.distNearestTSS = FALSE,
  annotation.col = NULL,
  met.metadata = NULL,
  exp.metadata = NULL,
  width = 10,
  height = 7,
  filename = NULL
)
}
\arguments{
\item{data}{A MultiAssayExperiment with a DNA methylation SummarizedExperiment (all probes) and a gene Expression SummarizedExperiment.}

\item{group.col}{A column from the sample matrix from the MultiAssayExperiment object. Accessed with colData(mae)}

\item{group1}{A group from group.col. ELMER will run group1 vs group2. 
That means, if direction is hyper, get probes
hypermethylated in group 1 compared to group 2.}

\item{group2}{A group from group.col. ELMER will run group1 vs group2. 
That means, if direction is hyper, get probes
hypermethylated in group 1 compared to group 2.}

\item{pairs}{List of probe and pair genes}

\item{subset}{Subset MAE object to keep only groups compared ?}

\item{cluster.within.groups}{Cluster columns based on the groups}

\item{plot.distNearestTSS}{Plot track with distNearestTSS ?}

\item{annotation.col}{A vector of columns from the sample matrix from the MultiAssayExperiment object. Accessed with colData(mae) 
to be added as annotation to the heatmap.}

\item{met.metadata}{A vector of metdatada columns available in the DNA methylation GRanges to should be added to the heatmap.}

\item{exp.metadata}{A vector of metdatada columns available in the Gene expression GRanges to should be added to the heatmap.}

\item{width}{Figure width}

\item{height}{Figure height}

\item{filename}{File names (.pdf) to save the file (i.e. "plot.pdf"). If NULL return plot.}
}
\value{
A heatmap
}
\description{
Heatmp plot of pairs gene and probes anti-correlated
}
\examples{
\dontrun{
  data <- ELMER:::getdata("elmer.data.example")
  group.col <- "subtype_Expression.Subtype"
  group1 <- "classical"
  group2 <- "secretory"
  pairs <- data.frame(Probe = c("cg15924102","cg19403323", "cg22396959"),
                      GeneID = c("ENSG00000196878", "ENSG00000009790", "ENSG00000009790" ),
                      Symbol = c("TRAF3IP3","LAMB3","LAMB3"),
                      Distance = c(6017,168499,0),
                      Raw.p = c(0.001,0.00001,0.001),
                      Pe = c(0.001,0.00001,0.001))
 heatmapPairs(
   data = data, group.col = group.col,
              group1 = group1, group2 = group2,
              annotation.col = c("ethnicity","vital_status","age_at_diagnosis"),
              pairs, filename = "heatmap.pdf",
              height = 4, width = 11
  )
  }
}
\author{
Tiago Chedraoui Silva (tiagochst at gmail.com)
}
