% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{metBoxPlot}
\alias{metBoxPlot}
\title{scatter.plot to plot scatter plots between gene expression and DNA methylation.}
\usage{
metBoxPlot(
  data,
  group.col,
  group1,
  group2,
  probe,
  min.samples = 5,
  minSubgroupFrac = 0.2,
  diff.dir = "hypo",
  legend.col = NULL,
  title = NULL,
  filename = NULL,
  save = TRUE
)
}
\arguments{
\item{data}{A multiAssayExperiment with DNA methylation and Gene Expression data. 
See \code{\link{createMAE}} function.}

\item{group.col}{A column defining the groups of the sample. You can view the 
available columns using: colnames(MultiAssayExperiment::colData(data)).}

\item{group1}{A group from group.col. ELMER will run group1 vs group2. 
That means, if direction is hyper, get probes
hypermethylated in group 1 compared to group 2.}

\item{group2}{A group from group.col. ELMER will run group1 vs group2. 
That means, if direction is hyper, get probes
hypermethylated in group 1 compared to group 2.}

\item{probe}{Character with probe name (i.e. "cg24517858")}

\item{min.samples}{Minimun number of samples to use in the analysis. Default 5.
If you have 10 samples in one group, percentage is 0.2 this will give 2 samples 
in the lower quintile, but then 5 will be used.}

\item{minSubgroupFrac}{A number ranges from 0 to 1 specifying the percentage of samples 
from group1 and group2 that are used to identify the differential methylation. 
Default is 0.2 because we did not expect all cases to be from a single molecular 
subtype.But, If you are working with molecular subtypes please set it to 1.}

\item{diff.dir}{A character can be "hypo" or "hyper", showing differential 
 methylation dirction.  It can be "hypo" which is only selecting hypomethylated probes; 
"hyper" which is only selecting hypermethylated probes;}

\item{legend.col}{legend title}

\item{title}{plot title}

\item{filename}{File names (.png) to save the file (i.e. "plot.png")}

\item{save}{Save plot as PNG}
}
\value{
Box plot
}
\description{
scatter.plot is a function to plot various scatter plots between gene expression and 
DNA methylation. When byPair is specified, scatter plot for individual probe-gene pairs
will be generated. When byProbe is specified, scatter plots for one probes with nearby
20 gene pairs will be generated. When byTF is specified, scatter plot for TF expression 
and average DNA methylation at certain motif sites will be generated.
}
\examples{
\dontrun{
  data <- ELMER:::getdata("elmer.data.example")
  group.col <- "subtype_Expression.Subtype"
  group1 <- "classical"
  group2 <- "secretory"
  metBoxPlot(data,
             group.col = group.col,
             group1 = group1,
             group2 = group2, 
             probe ="cg17898069",
             minSubgroupFrac = 0.2, 
             diff.dir = "hypo")
}
}
\author{
Tiago Chedraoui Silva (tiagochst at gmail.com)
}
