% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Small.R
\name{getTFBindingSites}
\alias{getTFBindingSites}
\title{Get MR TF binding regions infered by ELMER}
\usage{
getTFBindingSites(
  tf = NULL,
  results.dir = NULL,
  genome = "hg38",
  met.platform = "450K"
)
}
\arguments{
\item{tf}{TF name}

\item{results.dir}{path to the directory with the results 
(i.e. analysis/unsupervised/definition-Primary.solid.Tumor_vs_Solid.Tissue.Normal/hypo/)}

\item{genome}{Human genome (hg38, hg19)}

\item{met.platform}{DNA Methylation  Array platform (EPIC, 450K)}
}
\description{
Saves a bed file with the unmethylated probes (+-250bp) regions that was infered
to be bound by a given TF
}
\examples{
\dontrun{
  getTFBindingSites("HNF1A",
                    results.dir = "analysis/unsupervised/group-Tumor_vs_Normal/hypo/")
}
}
