% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictions.R
\name{predictions}
\alias{predictions}
\title{Performing Gene Function Prediction}
\usage{
predictions(genes.labels, network)
}
\arguments{
\item{genes.labels}{numeric array}

\item{network}{numeric array symmetric, gene-by-gene matrix}
}
\value{
scores numeric matrix
}
\description{
The function performs gene function prediction on the whole data set
using the 'guilt by association'-principle ([1]).
}
\examples{
genes.labels <- matrix( sample( c(0,1), 1000, replace=TRUE), nrow=100)
rownames(genes.labels) = paste('gene', 1:100, sep='')
colnames(genes.labels) = paste('function', 1:10, sep='')
net <- cor( matrix( rnorm(10000), ncol=100), method='spearman')
rownames(net) <- paste('gene', 1:100, sep='')
colnames(net) <- paste('gene', 1:100, sep='')

preds <- predictions(genes.labels, net) 

}
\keyword{association}
\keyword{by}
\keyword{function}
\keyword{gene}
\keyword{guilt}
\keyword{neighbor}
\keyword{prediction}
\keyword{voting}
