% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbor_voting.R
\name{neighbor_voting}
\alias{neighbor_voting}
\title{Evaluating Gene Function Prediction}
\usage{
neighbor_voting(
  genes.labels,
  network,
  nFold = 3,
  output = "AUROC",
  FLAG_DRAW = FALSE
)
}
\arguments{
\item{genes.labels}{numeric array}

\item{network}{numeric array symmetric, gene-by-gene matrix}

\item{nFold}{numeric value, default is 3}

\item{output}{string, default is AUROC}

\item{FLAG_DRAW}{binary flag to draw roc plot}
}
\value{
scores numeric matrix with a row for each gene label and columns
        auc: the average area under the ROC or PR curve for the neighbor voting predictor
             across cross validation replicates
        avg_node_degree: the average node degree
        degree_null_auc: the area the ROC or PR curve for the node degree predictor
}
\description{
The function performs gene function prediction based on 'guilt by association' 
using cross validation ([1]). Performance and significance are evaluated by 
calculating the AUROC or AUPRC of each functional group.
}
\examples{
genes.labels <- matrix( sample( c(0,1), 1000, replace=TRUE), nrow=100)
rownames(genes.labels) = paste('gene', 1:100, sep='')
colnames(genes.labels) = paste('function', 1:10, sep='')
net <- cor( matrix( rnorm(10000), ncol=100), method='spearman')
rownames(net) <- paste('gene', 1:100, sep='')
colnames(net) <- paste('gene', 1:100, sep='')

aurocs <- neighbor_voting(genes.labels, net, output = 'AUROC') 

avgprcs <- neighbor_voting(genes.labels, net, output = 'PR') 

}
\keyword{association}
\keyword{by}
\keyword{cross}
\keyword{evaluation}
\keyword{function}
\keyword{gene}
\keyword{guilt}
\keyword{neighbor}
\keyword{prediction}
\keyword{validation}
\keyword{voting}
