% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_binary_network.R
\name{build_binary_network}
\alias{build_binary_network}
\title{Builds a binary network}
\usage{
build_binary_network(data, list)
}
\arguments{
\item{data}{2-column matrix, each row a pair indicating a relationship or interaction}

\item{list}{string array of genes/labels/ids}
}
\value{
net matrix binary characterizing interactions
}
\description{
The function creates a gene-by-gene matrix with binary entries indicating interaction (1) 
or no interaction (0) between the genes.
}
\examples{
data <- cbind(edgeA=c('gene1','gene2'),edgeB=c('gene3','gene3'))
list <- c('gene1','gene2','gene3')
network <- build_binary_network(data,list)


}
\keyword{gene-by-gene}
\keyword{interaction}
\keyword{network}
