% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_plot.R
\name{regression_plot}
\alias{regression_plot}
\title{Create a Regression Plot with Faceting by Range}
\usage{
regression_plot(
  data,
  x_var,
  y_var,
  custom_range = c(0.1, 15, 30, 50, 75, 100),
  formula = y ~ x,
  plot_title = NULL
)
}
\arguments{
\item{data}{A data frame containing the variables to plot.}

\item{x_var}{A string specifying the name of the x-axis variable.}

\item{y_var}{A string specifying the name of the y-axis variable.}

\item{custom_range}{A numeric vector for defining custom ranges for the 'Percentage' column (default: c(0.1, 15, 30, 50, 75, 100)).}

\item{formula}{A formula for the regression equation (default: y ~ x).}

\item{plot_title}{A string specifying the title of the plot (default: NULL, no title will be shown if not provided).}
}
\value{
A ggplot2 object.
}
\description{
This function generates a customizable scatter plot with a linear regression line,
statistical equation, and facets based on a specified range variable.
The x and y variables are transformed using a natural log transformation (\code{log1p}) to handle zero values.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("metadata_full", package = "DspikeIn")

  plot_object <- regression_plot(
    data = metadata_full,
    x_var = "Observed",
    y_var = "Total_Reads_spiked",
    custom_range = c(0.1, 15, 30, 50, 75, 100)
  )

  # Print the plot output
  print(plot_object)
}
}
\seealso{
\code{\link[ggpubr]{stat_regline_equation}}, \code{\link[ggpubr]{stat_cor}}, \code{\link[ggplot2]{facet_wrap}}
}
