% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotbar_abundance.R
\name{plotbar_abundance}
\alias{plotbar_abundance}
\title{Taxa Bar Plot Without Aggregation (Relative or Absolute Abundance)}
\usage{
plotbar_abundance(
  physeq,
  tax_level = "Genus",
  normalize = TRUE,
  treatment_variable = "Host.taxon",
  abundance_type = "relative",
  x_angle = 25,
  fill_variable = tax_level,
  facet_variable = NULL,
  palette = DspikeIn::color_palette$mix_MG,
  legend_size = 11,
  legend_columns = 1,
  x_scale = "free",
  xlab = NULL
)
}
\arguments{
\item{physeq}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object.}

\item{tax_level}{A character string indicating the taxonomic rank (e.g., \code{"Genus"}).}

\item{normalize}{Logical; if \code{TRUE}, transforms to relative abundance. Default: \code{TRUE}.}

\item{treatment_variable}{Character; column name in sample metadata for x-axis grouping.}

\item{abundance_type}{Character; either \code{"relative"} or \code{"absolute"}. Default: \code{"relative"}.}

\item{x_angle}{Numeric; angle of x-axis tick labels. Default: \code{25}.}

\item{fill_variable}{Character; variable to fill bars by. Default: same as \code{tax_level}.}

\item{facet_variable}{Optional; column name for faceting. Default: \code{NULL}.}

\item{palette}{A named vector of colors to use for \code{fill_variable}.}

\item{legend_size}{Numeric; legend text size. Default: \code{11}.}

\item{legend_columns}{Integer; number of legend columns. Default: \code{1}.}

\item{x_scale}{Character; either \code{"free"} or \code{"fixed"} for facet x-axis scale. Default: \code{"free"}.}

\item{xlab}{Optional; override x-axis label. If \code{NULL}, x label is hidden.}
}
\value{
A \code{ggplot2} object containing a bar plot of taxa abundance.
}
\description{
Create a bar plot of relative or absolute abundances of microbial taxa
\strong{without using taxonomic glomming} (\code{tax_glom}). Works on raw or normalized data.
}
\examples{
\dontrun{
# Load required package
if (requireNamespace("phyloseq", quietly = TRUE)) {
  # Load example data
  data("physeq_ITSOTU", package = "DspikeIn")

  # Subset: Eurycea salamanders from Blue Ridge, exclude unwanted genera
  Des <- physeq_ITSOTU |>
    phyloseq::subset_taxa(Genus != "Dekkera") |>
    phyloseq::subset_samples(Clade.Order == "Caudate") |>
    phyloseq::subset_samples(Host.genus == "Eurycea") |>
    phyloseq::subset_samples(Ecoregion.III == "Blue Ridge")

  # Clean taxa: remove NAs or blanks in Phylum, filter low-abundance
  Des_filtered <- phyloseq::subset_taxa(Des, !is.na(Phylum) & Phylum != "")
  Des_ps <- phyloseq::prune_taxa(phyloseq::taxa_sums(Des_filtered) > 99, Des_filtered)

  # Plot taxa abundance with full control
  plotbar_abundance(
    physeq = Des_ps,
    normalize = TRUE,
    treatment_variable = "Diet",
    abundance_type = "absolute",
    x_angle = 0,
    fill_variable = "Phylum",
    palette = DspikeIn::color_palette$mix_MG,
    legend_size = 10,
    legend_columns = 1,
    x_scale = "free",
    xlab = NULL
  )
}
}

}
