% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setData.R
\docType{methods}
\name{setData}
\alias{setData}
\alias{setData,ChemoProtSet-method}
\alias{setData,ANY,ANY-method}
\title{Method for attaching and standardising data for objects of class 'ChemoProtSet'}
\usage{
setData(x, dataFrame, dataChannels, accessionChannel, uniquePeps = NA,
  sequenceChannel = NA, qualityChannel = NA, pdofpdChannel = NA,
  incGeneID = FALSE, geneIDFile = NA)

\S4method{setData}{ChemoProtSet}(x, dataFrame, dataChannels, accessionChannel,
  uniquePeps = NA, sequenceChannel = NA, qualityChannel = NA,
  pdofpdChannel = NA, incGeneID = FALSE, geneIDFile = NA)
}
\arguments{
\item{x}{object of class 'ChemoProtSet'}

\item{dataFrame}{data.frame of the input data set}

\item{dataChannels}{column names of dataFrame that correspond to data channels. These should be ordered in the format: rep1_concentration_0, ..., rep1_concentration_n, rep2_concentration_0, ...}

\item{accessionChannel}{string that is the same as the column name for the protein accessions in dataFrame}

\item{uniquePeps}{string that is the same as the column name for the number of unique peptides in dataFrame}

\item{sequenceChannel}{string that is the same as the column name for the peptide sequences in dataFrame}

\item{qualityChannel}{string that is the same as the column name for the peptide quality score in dataFrame}

\item{pdofpdChannel}{string that is the same as the column name for the pull-down of pull-down data in dataFrame}

\item{incGeneID}{boolean value indicating if a protein accession to gene ID file is supplied}

\item{geneIDFile}{data.frame containing a protein accession to gene ID conversion file}
}
\value{
object of class ChemoProtSet
}
\description{
This method will subset the orginal data set into the required columns, standardising column names in the process.
}
\examples{

channelNames <- c('Abundance..F1..126..Control..REP_1',
'Abundance..F1..127..Sample..REP_1',  'Abundance..F1..128..Sample..REP_1',
 'Abundance..F1..129..Sample..REP_1',  'Abundance..F1..130..Sample..REP_1',
'Abundance..F1..131..Sample..REP_1',  'Abundance..F2..126..Control..REP_2',
'Abundance..F2..127..Sample..REP_2', 'Abundance..F2..128..Sample..REP_2',
'Abundance..F2..129..Sample..REP_2',  'Abundance..F2..130..Sample..REP_2',
'Abundance..F2..131..Sample..REP_2')

ex <- new('ChemoProtSet')
ex<- setParameters(x = ex,chansVal = 6, repsVal = 2,dataTypeStr = 'intensity',
modelTypeStr = 'linear',PDBool = FALSE,removePepsBool = FALSE,
incPDofPDBool = FALSE,incGeneFileBool = FALSE,organismStr = 'H.sapiens', pearsonThrshVal = 0.4)
ex<- setData(x = ex, dataFrame = doschedaData, dataChannels = channelNames,
accessionChannel = 'Master.Protein.Accessions',
sequenceChannel = 'Sequence',qualityChannel = 'Qvality.PEP')

ex

}
\seealso{
\code{\link{DoschedaSet}}
}
