% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitModel.R
\docType{methods}
\name{fitModel}
\alias{fitModel}
\alias{fitModel,ChemoProtSet-method}
\alias{fitModel,ANY,ANY-method}
\title{Method to fit a model to an object of class 'ChemoProtSet'}
\usage{
fitModel(x)

\S4method{fitModel}{ChemoProtSet}(x)
}
\arguments{
\item{x}{object of class 'ChemoProtSet'}
}
\value{
object of class ChemoProtSet
}
\description{
Method to fit a model to an object of class 'ChemoProtSet'
}
\examples{
channelNames <- c('Abundance..F1..126..Control..REP_1',
'Abundance..F1..127..Sample..REP_1',  'Abundance..F1..128..Sample..REP_1',
 'Abundance..F1..129..Sample..REP_1',  'Abundance..F1..130..Sample..REP_1',
'Abundance..F1..131..Sample..REP_1',  'Abundance..F2..126..Control..REP_2',
'Abundance..F2..127..Sample..REP_2', 'Abundance..F2..128..Sample..REP_2',
'Abundance..F2..129..Sample..REP_2',  'Abundance..F2..130..Sample..REP_2',
'Abundance..F2..131..Sample..REP_2')
ex <- new('ChemoProtSet')
ex<- setParameters(x = ex,chansVal = 6, repsVal = 2,dataTypeStr = 'intensity',
 modelTypeStr = 'linear',PDBool = FALSE,removePepsBool = FALSE,
 incPDofPDBool = FALSE,incGeneFileBool = FALSE,organismStr = 'H.sapiens', pearsonThrshVal = 0.4)
ex<- setData(x = ex, dataFrame = doschedaData, dataChannels = channelNames,
accessionChannel = 'Master.Protein.Accessions',
              sequenceChannel = 'Sequence', qualityChannel = 'Qvality.PEP' )
ex <- removePeptides(ex,removePeps = FALSE)
ex <- runNormalisation(ex)
ex <- fitModel(ex)
ex

ex <- processedExample
ex <- runNormalisation(ex)
ex <- fitModel(ex)

ex
}
\seealso{
\code{\link{DoschedaSet}}
}
