% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{lmCSmatNoNA}
\alias{lmCSmatNoNA}
\title{Cosinor Without NA Values}
\usage{
lmCSmatNoNA(x, zts, per = 24)
}
\arguments{
\item{x}{- numeric data matrix}

\item{zts}{- numeric vector of length ncol(data) representing time points
for each data column}

\item{per}{- period of oscillations (default=24)}
}
\value{
data frame with the following estimated statistics:
\itemize{
        \item acrophase - acrophases
        \item amplitude - amplitudes
        \item Rsq - r-squared values
        \item pvalue - p-values
        \item mesor - intercept coefficient
        \item sincoef - sine coefficient
        \item coscoef - cosine coefficient
}
}
\description{
Fixed period cosinor on each row of a matrix with no missing values.
}
\details{
Fits a cosinor model to each row of a matrix that has no NA values.
}
\examples{
\dontrun{
tmpData <- matrix(rnorm(24 * 1000), ncol = 24)
lmCSmat(tmpData, 1:24, 24)
}
}
\author{
Karolis Koncevičius
}
\keyword{internal}
