% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nUniqueNeighDons.R
\name{nUniqueNeighDons}
\alias{nUniqueNeighDons}
\title{How many donors are contained among the nearest neighbors?}
\usage{
nUniqueNeighDons(
  donorData,
  euclidSpaceData,
  neighRows = seq_len(nrow(as.matrix(donorData))),
  ctrlRows,
  kNeighK = max(100, round(nrow(as.matrix(euclidSpaceData))/10000)),
  kMeansK = max(1, round(nrow(as.matrix(euclidSpaceData))/1000))
)
}
\arguments{
\item{donorData}{The donor information.}

\item{euclidSpaceData}{The data cloud in which the nearest neighbors for the
events should be identified. Can be a vector, matrix or dataframe.}

\item{neighRows}{The rows in the dataset that correspond to the neighbors
of the donorData points. This can be all the donorData points, or a subset,
depending on the setup.}

\item{ctrlRows}{Optionally, a set of control rows that are used to remove
background signal from the neighRows data before sending the data back.}

\item{kNeighK}{The number of nearest neighbors.}

\item{kMeansK}{The number of clusters in the initial step of the algorithm.
A higher number leads to shorter runtime, but potentially lower accuracy.}
}
\value{
An object of the same dimensions as donorData that has been smoothed.
}
\description{
This function constructs a variable that for each event shows the number of
donors in its nearest neighbor surroundings. It builds on the same
idea as has been put forward in the Sconify package:
-Burns TJ (2019). Sconify: A toolkit for performing KNN-based statistics for
flow and mass cytometry data. R package version 1.4.0 and
-Hart GT, Tran TM, Theorell J, Schlums H, Arora G, Rajagopalan S, et al.
Adaptive NK cells in people exposed to Plasmodium falciparum correlate
with protection from malaria. J Exp Med. 2019 Jun 3;216(6):1280–90.
First, the k nearest neighbors are defined for cell x. Then, the number of
donors in the k nearest neighbor cloud is returned.
}
\examples{
data(testData)
data(testDataSNE)
euclidSpaceData <-
    testData[, c(
        "SYK", "CD16", "CD57", "EAT.2",
        "CD8", "NKG2C", "CD2", "CD56"
    )]
\dontrun{
nDonorsVector <- nUniqueNeighDons(
    donorData = as.numeric(testData$label),
    euclidSpaceData
)
}
}
