% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dColorPlot.R
\name{dColorPlot}
\alias{dColorPlot}
\title{Display third variable as color on a 2D plot}
\usage{
dColorPlot(
  colorData,
  controlData,
  xYData,
  colorScale = "rich_colors",
  plotName = "default",
  densContour = TRUE,
  title = FALSE,
  plotDir = "default",
  truncate = TRUE,
  bandColor = "black",
  dotSize = 500/sqrt(nrow(xYData)),
  continuous = "default",
  multiCore = "default",
  nCores = "default",
  createOutput = TRUE
)
}
\arguments{
\item{colorData}{A numeric matrix or dataframe or a vector, be it numeric,
charater or factor, that should be used to define the colors on the plot.
A pre-made vector of colors is also accepted.}

\item{controlData}{Optional. A numeric/integer vector or dataframe of values
that could be used to define the range of the colorData. If no control data
is present, the function defaults to using the colorData as control data.}

\item{xYData}{These variables create the field on which the colorData will
be displayed. It needs to be a matrix or dataframe with two columns and the
same number of rows as the colorData object.}

\item{colorScale}{This argument controls the colors in the plot. See
\code{\link{dColorVector}} for alternatives.}

\item{plotName}{The name(s) for the plot(s). 'default' returns the column
names of the colorData object in the case this is a dataframe and otherwise
returns the somewhat generic name 'testVariable'. It can be substituted with
a string (in the case colorData is a vector) or vector of strings, as long as
it has the same length as the number of columns in colorData.}

\item{densContour}{If density contours should be created for the plot(s) or
not. Defaults to TRUE. If a density object, as generated by dContours, is
included, this will be used instead.}

\item{title}{If there should be a title displayed on the plotting field. As
the plotting field is saved a jpeg, this title cannot be removed as an object
afterwards, as it is saved as coloured pixels. To simplify usage for
publication, the default is FALSE, as the files are still named, eventhough
no title appears on the plot.}

\item{plotDir}{If different from the current directory. If specified and
non-existent, the function creates it. If "." is specified, the plots will be
saved at the current directory. By default, a new directory is added if the
created plots will be more than 1.}

\item{truncate}{If truncation of the most extreme values should be performed
for the visualizations. Three possible values: TRUE, FALSE, and a vector
with two values indicating the low and high threshold quantiles for
truncation.}

\item{bandColor}{The color of the contour bands. Defaults to black.}

\item{dotSize}{Simply the size of the dots. The default makes the dots
maller the more observations that are included.}

\item{continuous}{Boolean. Is the colorData parameter continuous? If
default, then only numeric vectors with more than 20 values are considered
continuous.This only applies to situations with single vectors. In situations
where a dataframe is added as colorData, all variables are considered
continuous.}

\item{multiCore}{If the algorithm should be performed on multiple cores.
This increases the speed if the dataset is medium-large (>100000 rows) and
has at least 5 columns. Default is TRUE when these above criteria are met and
FALSE otherwise.}

\item{nCores}{If multiCore is TRUE, then this sets the number of parallel
processes. The default is currently 87.5 percent with a cap on 10 cores, as
no speed increase is generally seen above 10 cores for normal computers.}

\item{createOutput}{For testing purposes. Defaults to TRUE. If FALSE, no
plots are generated.}
}
\value{
Plots showing the colorData displayed as color on the field created
by xYData.
}
\description{
Function to overlay one variable for a set of observations on a field
created by two other variables known for the same observations. The plot is
constructed primarily for displaying variables on 2D-stochastic neighbour
embedding fields, but can be used for any sets of (two or) three variables
known for the same observations. As the number of datapoints is often very
high, the files would, if saved as pdf of another vector based file type
become extremely big. For this reason, the plots are saved as jpeg and no
axes or anything alike are added, to simplify usage in publications.
}
\examples{

# Load some data
data(testData)
\dontrun{
# Load or create the dimensions that you want to plot the result over.
# uwot::umap recommended due to speed, but tSNE or other method would
# work as fine.
data(testDataSNE)

# Run the function for two of the variables
dColorPlot(colorData = testData[2:3], xYData = testDataSNE$Y)

# Now each depeche cluster is plotted separately and together.

# Run the clustering function. For more rapid example execution,
# a depeche clustering of the data is included
# testDataDepeche <- depeche(testData[,2:15])
data(testDataDepeche)

dColorPlot(
    colorData = testDataDepeche$clusterVector,
    xYData = testDataSNE$Y, plotName = "clusters"
)
}
}
\seealso{
\code{\link{dDensityPlot}}, \code{\link{dResidualPlot}},
\code{\link{dWilcox}}, \code{\link{dColorVector}}
}
