% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DelayedDataFrame-method.R
\name{as.list,DelayedDataFrame-method}
\alias{as.list,DelayedDataFrame-method}
\alias{names,DelayedDataFrame-method}
\alias{cbind,DelayedDataFrame-method}
\alias{bindROWS,DelayedDataFrame-method}
\alias{extractROWS,DelayedDataFrame,ANY-method}
\alias{extractROWS,DelayedDataFrame-method}
\alias{extractCOLS,DelayedDataFrame-method}
\alias{replaceCOLS,DelayedDataFrame-method}
\alias{mergeROWS,DelayedDataFrame-method}
\alias{[,DelayedDataFrame,ANY,ANY,ANY-method}
\alias{"["}
\alias{"[,DelayedDataFrame-method"}
\title{DelayedDataFrame related methods.}
\usage{
\S4method{as.list}{DelayedDataFrame}(x, use.names = TRUE)

\S4method{names}{DelayedDataFrame}(x)

\S4method{cbind}{DelayedDataFrame}(..., deparse.level = 1)

\S4method{bindROWS}{DelayedDataFrame}(
  x,
  objects = list(),
  use.names = TRUE,
  ignore.mcols = FALSE,
  check = TRUE
)

\S4method{extractROWS}{DelayedDataFrame,ANY}(x, i)

\S4method{extractCOLS}{DelayedDataFrame}(x, i)

\S4method{replaceCOLS}{DelayedDataFrame}(x, i, value)

\S4method{mergeROWS}{DelayedDataFrame}(x, i, value)

\S4method{[}{DelayedDataFrame,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{\code{as.list,DelayedDataFrame}: a \code{DelayedDataFrame}
object. OR, \code{[,DelayedDataFrame}: \code{DelayedDataFrame}
object to be subsetted.}

\item{use.names}{\code{as.list,DelayedDataFrame}: whether to use
the colnames of \code{DelayedDataFrame} as the names for the
returned list. OR, \code{bindROWS,DelayedDataFrame}: whether to
use rownames of the input arguments. Default is TRUE.}

\item{...}{\code{cbind,DelayedDataFrame}: One or more vector-like
or matrix-like objects. These can be given as named
arguments. OR, \code{[,DelayedDataFrame}: other arguments to
pass.}

\item{deparse.level}{See ‘?base::cbind’ for a description of this
argument.}

\item{objects}{the \code{DelayedDataFrame} objects to be passed
into \code{bindROWS}.}

\item{ignore.mcols}{Logical. This argument is ignored for
\code{bindROWS,DelayedDataFrame}.}

\item{check}{Logical. This argument is ignored for
\code{bindROWS,DelayedDataFrame}.}

\item{i}{row subscript}

\item{value}{the new values in the \code{i,j} subscripts of
\code{DelayedDataFrame} object.}

\item{j}{col subscript}

\item{drop}{if drop with reduced dimension, default is TRUE.}
}
\value{
colnames of \code{DelayedDataFrame}
}
\description{
\code{as.list}, \code{rbind} would incur realization
    of the \code{lazyIndex} slot in \code{DelayedDataFrame} object.

\code{cbind} for DelayedDataFrame inherits the
    lazyIndex's if inputs have any DelayedDataFrame
    objects. Otherwise, return a new DelayedDataFrame with NULL
    lazyIndexes.
}
