% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_marker_express.R
\name{plot_marker_express}
\alias{plot_marker_express}
\title{Plot gene expression violin plots for top marker genes for one cell type}
\usage{
plot_marker_express(
  sce,
  stats,
  cell_type,
  n_genes = 4,
  rank_col = "MeanRatio.rank",
  anno_col = "MeanRatio.anno",
  gene_col = "gene",
  cellType_col = "cellType",
  color_pal = NULL,
  plot_points = FALSE,
  ncol = 2
)
}
\arguments{
\item{sce}{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment-class} object}

\item{stats}{A \code{data.frame()} generated by \code{get_mean_ratio()} and/or
\code{findMarkers_1vAll()}.}

\item{cell_type}{A \code{character()} target cell type to plot markers for}

\item{n_genes}{An \code{integer(1)} of number of markers you'd like to plot}

\item{rank_col}{The \code{character(1)} name of column to rank genes by in
\code{stats}.}

\item{anno_col}{The \code{character(1)} name of column containing annotation in
\code{stats}.}

\item{gene_col}{The \code{character(1)} name of column containing gene name in
\code{stats} should be the same syntax as \code{rownames(sce)}.}

\item{cellType_col}{The \code{character(1)} name of \code{colData()} column containing
cell type for \code{sce} data. It should match \code{cellType.target} in \code{stats}.}

\item{color_pal}{A named \code{character(1)} vector that contains a color palette
matching the \code{cell_type} values.}

\item{plot_points}{A \code{logical(1)} indicating whether to plot points over the
violin, defaults to \code{FALSE} as these often become over plotted and quite
large (especially when saved as PDF).}

\item{ncol}{An \code{integer(1)} specifying the number of columns for the facet in
the final plot. Defaults to 2.}
}
\value{
A \code{ggplot2} object created with \code{plot_gene_express()}. It is
a \code{scater::plotExpression()} style violin plot for selected marker genes.
}
\description{
This function plots the top n marker genes for a specified cell type based off of
the \code{stats} table from \code{get_mean_ratio()}.
The gene expression is plotted as violin plot with \code{plot_gene_express} and adds
annotations to each plot.
}
\examples{
## Download the processed study data from
## <https://github.com/LieberInstitute/Human_DLPFC_Deconvolution>.
if (!exists("sce_DLPFC_example")) sce_DLPFC_example <- fetch_deconvo_data("sce_DLPFC_example")

## load example marker stats
data("marker_test")

## Plot the top markers for Astrocytes
plot_marker_express(
    sce = sce_DLPFC_example,
    stat = marker_test,
    cellType_col = "cellType_broad_hc",
    cell_type = "Astro",
    gene_col = "gene"
)
}
\seealso{
Other expression plotting functions: 
\code{\link{plot_gene_express}()},
\code{\link{plot_marker_express_ALL}()},
\code{\link{plot_marker_express_List}()}
}
\concept{expression plotting functions}
