% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findMarkers_1vAll.R
\name{findMarkers_1vAll}
\alias{findMarkers_1vAll}
\title{Calculate 1 vs. All standard fold change for each gene x cell type, wrapper
function for \code{scran::findMarkers()}.}
\usage{
findMarkers_1vAll(
  sce,
  assay_name = "counts",
  cellType_col = "cellType",
  add_symbol = FALSE,
  mod = NULL,
  verbose = TRUE,
  direction = "up"
)
}
\arguments{
\item{sce}{A
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}
object.}

\item{assay_name}{Name of the assay to use for calculation. See
see \code{assayNames(sce)} for possible values.}

\item{cellType_col}{Column name on \code{colData(sce)} that denotes the cell type.}

\item{add_symbol}{A \code{logical(1)} indicating whether to add the gene symbol
column to the marker stats table.}

\item{mod}{A \code{character(1)} string specifying the model used as design in
\code{scran::findMarkers()}. It can be \code{NULL} (default) if there are no blocking
terms with uninteresting
factors as documented at \link[scran:pairwiseTTests]{pairwiseTTests}.}

\item{verbose}{A \code{logical(1)} choosing whether to print progress messages or
not.}

\item{direction}{A \code{character(1)} for the choice of direction tested for
gene cell type markers: \code{"up"} (default), \code{"any"}, or \code{"down"}. Impacts
p-values: if \code{"up"} genes with logFC < 0 will have \code{p.value = 1}.}
}
\value{
A \code{tibble::tibble()} of 1 vs. ALL standard log fold change + p-values
for each gene x cell type.
\itemize{
\item \code{gene} is the name of the gene (from \code{rownames(sce)}).
\item \code{logFC} the log fold change from the DE test
\item \code{log.p.value} the log of the p-value of the DE test
\item \code{log.FDR} the log of the False Discovery Rate adjusted p.value
\item \code{std.logFC} the standard logFC.
\item \code{cellType.target} the cell type we're finding marker genes for
\item \code{std.logFC.rank} the rank of \code{std.logFC} for each cell type
\item \code{std.logFC.anno} is an annotation of the \code{std.logFC} value
helpful for plotting.
}
}
\description{
For each cell type, this function computes the statistics comparing that cell
type (the "1") against all other cell types combined ("All").
}
\details{
See \url{https://github.com/MarioniLab/scran/issues/57} for a more in depth
discussion about the standard log fold change statistics provided by
\code{scran::findMarkers()}.

See also \url{https://youtu.be/IaclszgZb-g} for a LIBD
rstats club presentation on "Finding and interpreting marker genes in
sc/snRNA-seq data". The companion notes are available at
\url{https://docs.google.com/document/d/1BeMtKgE7gpmNywInndVC9o_ufopn-U2EZHB32bO7ObM/edit?usp=sharing}.
}
\examples{
## load example SingleCellExperiment
if (!exists("sce_DLPFC_example")) sce_DLPFC_example <- fetch_deconvo_data("sce_DLPFC_example")
## Explore properties of the sce object
sce_DLPFC_example

## this data contains logcounts of gene expression
SummarizedExperiment::assays(sce_DLPFC_example)$logcounts[1:5, 1:5]

## nuclei are classified in to cell types
table(sce_DLPFC_example$cellType_broad_hc)

## Get the 1vALL stats for each gene for each cell type defined in
## `cellType_broad_hc`
marker_stats_1vAll <- findMarkers_1vAll(
    sce = sce_DLPFC_example,
    assay_name = "logcounts",
    cellType_col = "cellType_broad_hc",
    mod = "~BrNum"
)

## explore output, top markers have high logFC
head(marker_stats_1vAll)

}
\seealso{
Other marker gene functions: 
\code{\link{get_mean_ratio}()}
}
\concept{marker gene functions}
