% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichDGNv.R
\name{enrichDGNv}
\alias{enrichDGNv}
\title{enrichDGN}
\usage{
enrichDGNv(
  snp,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe,
  minGSSize = 10,
  maxGSSize = 500,
  qvalueCutoff = 0.2,
  readable = FALSE
)
}
\arguments{
\item{snp}{a vector of SNP}

\item{pvalueCutoff}{pvalue cutoff}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{universe}{background genes}

\item{minGSSize}{minimal size of genes annotated by NCG category for testing}

\item{maxGSSize}{maximal size of each geneSet for analyzing}

\item{qvalueCutoff}{qvalue cutoff}

\item{readable}{whether mapping gene ID to gene Name}
}
\value{
A \code{enrichResult} instance
}
\description{
Enrichment analysis based on the DisGeNET (\url{http://www.disgenet.org/})
}
\details{
given a vector of genes, this function will return the enrichment NCG
categories with FDR control
}
\references{
Janet et al. (2015) DisGeNET: a discovery platform for the dynamical exploration of human diseases and their genes. \emph{Database} bav028
\url{http://database.oxfordjournals.org/content/2015/bav028.long}
}
\author{
Guangchuang Yu
}
