% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_filter.R
\name{distance_filter}
\alias{distance_filter}
\title{Select barcode combinations with error correction properties}
\usage{
distance_filter(index_df, combinations_m, metric, d)
}
\arguments{
\item{index_df}{A dataframe containing barcodes identifiers, 
corresponding DNA sequences along with GC content and presence 
of homopolymers.}

\item{combinations_m}{A matrix of compatible barcode combinations.}

\item{metric}{The type of distance (hamming or seqlev or phaseshift).}

\item{d}{The minimum value of the distance.}
}
\value{
A filtered matrix containing the identifiers of the barcodes
satisfying the distance constraints.
}
\description{
Filters a list of barcode combinations for a given distance metric 
(hamming or seqlev) and threshold in order to produce a list of barcodes
satisfying the distance constraints.
}
\details{
The "hamming" distance is suitable for correcting substitution errors. 
The "seqlev" distance is suitable for correcting both 
substitution and insertion/deletion errors.
}
\examples{
barcodes <- DNABarcodeCompatibility::IlluminaIndexes
m <- get_all_combinations(barcodes, 2, 4)
distance_filter(barcodes, m, "hamming", 3)

}
\references{
Buschmann, T. 2015. 
The Systematic Design and Application of Robust DNA Barcodes.

Buschmann, T. 2017. 
DNABarcodes: an R package for the systematic construction of 
DNA sample tags. Bioinformatics 33, 920–922.
}
\seealso{
\code{\link{get_all_combinations}}, 
\code{\link{get_random_combinations}}
}
