% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeDMRs.R
\name{mergeDMRsIteratively}
\alias{mergeDMRsIteratively}
\title{Merge DMRs iteratively}
\usage{
mergeDMRsIteratively(
  DMRs,
  minGap,
  respectSigns = TRUE,
  methylationData1,
  methylationData2,
  context = "CG",
  minProportionDifference = 0.4,
  minReadsPerCytosine = 4,
  pValueThreshold = 0.01,
  test = "fisher",
  alternative = "two.sided",
  parallel = FALSE,
  BPPARAM = NULL,
  cores = NULL
)
}
\arguments{
\item{DMRs}{the list of DMRs as a \code{\link{GRanges}} object; 
e.g. see \code{\link{computeDMRs}}}

\item{minGap}{DMRs separated by a gap of at least \code{minGap} are not 
merged.}

\item{respectSigns}{logical value indicating whether to respect the sign when 
joining DMRs.}

\item{methylationData1}{the methylation data in condition 1
(see \code{\link{methylationDataList}}).}

\item{methylationData2}{the methylation data in condition 2
(see \code{\link{methylationDataList}}).}

\item{context}{the context in which the DMRs are computed (\code{"CG"}, 
\code{"CHG"} 
or \code{"CHH"}).}

\item{minProportionDifference}{two adjacent DMRs are merged only if the 
difference in methylation proportion of the new DMR is higher than 
\code{minProportionDifference}.}

\item{minReadsPerCytosine}{two adjacent DMRs are merged only if the number of 
reads per cytosine of the new DMR is higher than \code{minReadsPerCytosine}.}

\item{pValueThreshold}{two adjacent DMRs are merged only if the p-value of 
the new DMR (see \code{test} below) is lower than \code{pValueThreshold}. 
Note that we adjust the p-values using the Benjamini and Hochberg's method to 
control the false discovery rate.}

\item{test}{the statistical test used to call DMRs (\code{"fisher"} for 
Fisher's exact test or \code{"score"} for Score test).}

\item{alternative}{indicates the alternative hypothesis and must be one of 
\code{"two.sided"}, \code{"greater"} or \code{"less"}.}

\item{parallel}{Logical; run in parallel if \code{TRUE}.}

\item{BPPARAM}{A \code{BiocParallelParam} object controlling parallel execution.
This value will automatically set when parallel is \code{TRUE}, also able to set as manually.}

\item{cores}{Integer number of workers (must not exceed BPPARAM$workers).
This value will automatically set as the maximum number of system workers,
also able to set as manually.}
}
\value{
the reduced list of DMRs as a \code{\link{GRanges}} object; 
e.g. see \code{\link{computeDMRs}}
}
\description{
This function takes a list of DMRs and attempts to merge DMRs while keeping 
the new DMRs statistically significant.
}
\examples{
# load the methylation data
data(methylationDataList)

#load the DMRs in CG context they were computed with minGap = 200
data(DMRsNoiseFilterCG)


#merge the DMRs 
DMRsNoiseFilterCGLarger <- mergeDMRsIteratively(DMRsNoiseFilterCG[1:100], 
                           minGap = 500, respectSigns = TRUE, 
                           methylationDataList[["WT"]], 
                           methylationDataList[["met1-3"]],
                           context = "CG", minProportionDifference=0.4, 
                           minReadsPerCytosine = 1, pValueThreshold=0.01, 
                           test="score",alternative = "two.sided")


\dontrun{
#set genomic coordinates where to compute DMRs
regions <- GRanges(seqnames = Rle("Chr3"), ranges = IRanges(1,1E5))

# compute DMRs and remove gaps smaller than 200 bp
DMRsNoiseFilterCG200 <- computeDMRs(methylationDataList[["WT"]], 
                       methylationDataList[["met1-3"]], regions = regions, 
                       context = "CG", method = "noise_filter", 
                       windowSize = 100, kernelFunction = "triangular",  
                       test = "score", pValueThreshold = 0.01, 
                       minCytosinesCount = 1, minProportionDifference = 0.4, 
                       minGap = 200, minSize = 0, minReadsPerCytosine = 1, 
                       cores = 1)
                       
DMRsNoiseFilterCG0 <- computeDMRs(methylationDataList[["WT"]], 
                       methylationDataList[["met1-3"]], regions = regions, 
                       context = "CG", method = "noise_filter", 
                       windowSize = 100, kernelFunction = "triangular",  
                       test = "score", pValueThreshold = 0.01, 
                       minCytosinesCount = 1, minProportionDifference = 0.4, 
                       minGap = 0, minSize = 0, minReadsPerCytosine = 1, 
                       cores = 1)
DMRsNoiseFilterCG0Merged200 <- mergeDMRsIteratively(DMRsNoiseFilterCG0, 
                             minGap = 200, respectSigns = TRUE, 
                             methylationDataList[["WT"]], 
                             methylationDataList[["met1-3"]],
                             context = "CG", minProportionDifference=0.4, 
                             minReadsPerCytosine = 1, pValueThreshold=0.01, 
                             test="score",alternative = "two.sided")                      

#check that all newley computed DMRs are identical
print(all(DMRsNoiseFilterCG200 == DMRsNoiseFilterCG0Merged200))

}

}
\seealso{
\code{\link{filterDMRs}}, \code{\link{computeDMRs}}, 
\code{\link{analyseReadsInsideRegionsForCondition}} and 
\code{\link{DMRsNoiseFilterCG}}
}
\author{
Nicolae Radu Zabet
}
