% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methHMEM-method.R
\name{methHMEM-method}
\alias{methHMEM-method}
\alias{methHMEM,BSData-method}
\alias{methHMEM}
\title{methHMEM method}
\usage{
methHMEM(object, MaxK, MaxEmiter, epsEM, useweight, mc.cores)

\S4method{methHMEM}{BSData}(object, MaxK, MaxEmiter, epsEM, useweight, mc.cores)
}
\arguments{
\item{object}{A \code{\link{BSData-class}} or \code{\link{BSDMCs-class}}
object}

\item{MaxK}{An integer value}

\item{MaxEmiter}{An integer value}

\item{epsEM}{A positive numeric value}

\item{useweight}{A logical value}

\item{mc.cores}{An integer greater than 0}
}
\value{
\code{\link{BSDMCs-class}} object
}
\description{
Estimates the HMM methylation paths and the HMM order for
each sample using the EM algorithm
}
\examples{
set.seed(1980)
nr <- 150; nc <- 8
metht <- matrix(as.integer(runif(nr * nc, 0, 100)), nr)
methc <- matrix(rbinom(n=nr*nc,c(metht),prob = runif(nr*nc)),nr,nc)
r1 <- GRanges(rep('chr1', nr), IRanges(1:nr, width=1), strand='*')
names(r1) <- 1:nr
cd1 <- DataFrame(Group=rep(c('G1','G2'),each=nc/2),row.names=LETTERS[1:nc])
OBJ1 <- cBSData(rowRanges=r1,methReads=methc,totalReads=metht,colData=cd1)
OBJ2 <- methHMEM(OBJ1, MaxK=2, mc.cores=2)
OBJ2
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
