#' TestData: A test dataset for DEsingle
#'
#' A toy dataset containing a single-cell RNA-seq (scRNA-seq) read counts matrix and its grouping information.
#'
#' \itemize{
#'   \item counts. A matrix of raw read counts of scRNA-seq data which has 200 genes (rows) and 150 cells (columns).
#'   \item group. A vector of factor specifying the two groups to be compared in \code{counts}. Also could be generated by: \code{group <- factor(c(rep(1,50), rep(2,100)))}
#' }
#'
#' @name TestData
#' @aliases counts group
#' @docType data
#' @keywords data
#' @usage data(TestData)
#' @format
#' \itemize{
#'   \item counts. A non-negative integer matrix of scRNA-seq raw read counts, rows are genes and columns are cells.
#'   \item group. A vector of factor specifying the two groups to be compared, corresponding to the columns of the \code{counts}.
#' }
#' @source Petropoulos S, et al. Cell, 2016, 165(4): 1012-1026.
#' @seealso
#' \code{\link{DEsingle}}, for the detection of differentially expressed genes from scRNA-seq data.
#'
#' \code{\link{DEtype}}, for the classification of differentially expressed genes found by \code{\link{DEsingle}}.
#'
#' @examples
#' # Load test data for DEsingle
#' data(TestData)
#'
#' # Specifying the two groups to be compared
#' # The sample number in group 1 and group 2 is 50 and 100 respectively
#' group <- factor(c(rep(1,50), rep(2,100)))
#'
#' # Detecting the differentially expressed genes
#' results <- DEsingle(counts = counts, group = group)
#'
#' # Dividing the differentially expressed genes into 3 categories
#' results.classified <- DEtype(results = results, threshold = 0.05)
#'
NULL




