% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{process}
\alias{process}
\title{Proteomics data processing}
\usage{
process(
  se,
  thr = 0,
  fun = c("man", "bpca", "knn", "QRILC", "MLE", "MinDet", "MinProb", "min", "zero",
    "mixed", "nbavg"),
  ...
)
}
\arguments{
\item{se}{SummarizedExperiment,
Proteomics data with unique names and identifiers
annotated in 'name' and 'ID' columns.
The appropriate columns and objects can be generated
using the wrapper import functions \code{\link{import_MaxQuant}}
and \code{\link{import_IsobarQuant}} or the generic functions
\code{\link{make_se}} and \code{\link{make_se_parse}}.}

\item{thr}{Integer(1),
Sets the threshold for the allowed number of missing values per condition.}

\item{fun}{"man", "bpca", "knn", "QRILC", "MLE", "MinDet",
"MinProb", "min", "zero", "mixed" or "nbavg",
Function used for data imputation based on \code{\link{manual_impute}}
and \code{\link[MSnbase:impute]{impute}}.}

\item{...}{Additional arguments for imputation functions as depicted in
\code{\link{manual_impute}} and \code{\link[MSnbase:impute]{impute}}.}
}
\value{
A filtered, normalized and imputed SummarizedExperiment object.
}
\description{
\code{process} performs data processing on a SummarizedExperiment object.
It (1) filters a proteomics dataset based on missing values,
(2) applies variance stabilizing normalization and
(3) imputes eventual remaining missing values.
}
\examples{
# Load datasets
data <- UbiLength
exp_design <- UbiLength_ExpDesign

# Import data
se <- import_MaxQuant(data, exp_design)

# Process data
processed <- process(se)
}
