% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_results.R
\name{plot_volcano}
\alias{plot_volcano}
\title{Volcano plot}
\usage{
plot_volcano(
  dep,
  contrast,
  label_size = 3,
  add_names = TRUE,
  adjusted = FALSE,
  plot = TRUE
)
}
\arguments{
\item{dep}{SummarizedExperiment,
Data object for which differentially enriched proteins are annotated
(output from \code{\link{test_diff}()} and \code{\link{add_rejections}()}).}

\item{contrast}{Character(1),
Specifies the contrast to plot.}

\item{label_size}{Integer(1),
Sets the size of name labels.}

\item{add_names}{Logical(1),
Whether or not to plot names.}

\item{adjusted}{Logical(1),
Whether or not to use adjusted p values.}

\item{plot}{Logical(1),
If \code{TRUE} (default) the volcano plot is produced.
Otherwise (if \code{FALSE}), the data which the
volcano plot is based on are returned.}
}
\value{
A volcano plot (generated by \code{\link[ggplot2]{ggplot}})
}
\description{
\code{plot_volcano} generates a volcano plot for a specified contrast.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
imputed <- impute(norm, fun = "MinProb", q = 0.01)

# Test for differentially expressed proteins
diff <- test_diff(imputed, "control", "Ctrl")
dep <- add_rejections(diff, alpha = 0.05, lfc = 1)

# Plot volcano
plot_volcano(dep, 'Ubi6_vs_Ctrl', label_size = 5, add_names = TRUE)
plot_volcano(dep, 'Ubi6_vs_Ctrl', label_size = 5,
   add_names = TRUE, adjusted = TRUE)
plot_volcano(dep, 'Ubi6_vs_Ctrl', add_names = FALSE)
plot_volcano(dep, 'Ubi4_vs_Ctrl', label_size = 5, add_names = TRUE)
}
