% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_explore.R
\name{plot_pca}
\alias{plot_pca}
\title{Plot PCA}
\usage{
plot_pca(
  dep,
  x = 1,
  y = 2,
  indicate = c("condition", "replicate"),
  label = FALSE,
  n = 500,
  point_size = 4,
  label_size = 3,
  plot = TRUE
)
}
\arguments{
\item{dep}{SummarizedExperiment,
Data object for which differentially enriched proteins are annotated
(output from \code{\link{test_diff}()} and \code{\link{add_rejections}()}).}

\item{x}{Integer(1),
Sets the principle component to plot on the x-axis.}

\item{y}{Integer(1),
Sets the principle component to plot on the y-axis.}

\item{indicate}{Character,
Sets the color, shape and facet_wrap of the plot
based on columns from the experimental design (colData).}

\item{label}{Logical,
Whether or not to add sample labels.}

\item{n}{Integer(1),
Sets the number of top variable proteins to consider.}

\item{point_size}{Integer(1),
Sets the size of the points.}

\item{label_size}{Integer(1),
Sets the size of the labels.}

\item{plot}{Logical(1),
If \code{TRUE} (default) the PCA plot is produced.
Otherwise (if \code{FALSE}), the data which the
PCA plot is based on are returned.}
}
\value{
A scatter plot (generated by \code{\link[ggplot2]{ggplot}}).
}
\description{
\code{plot_pca} generates a PCA plot using the top variable proteins.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
imputed <- impute(norm, fun = "MinProb", q = 0.01)

# Test for differentially expressed proteins
diff <- test_diff(imputed, "control", "Ctrl")
dep <- add_rejections(diff, alpha = 0.05, lfc = 1)

# Plot PCA
plot_pca(dep)
plot_pca(dep, indicate = "condition")
}
