% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_QC.R
\name{plot_p_hist}
\alias{plot_p_hist}
\title{Plot a P value histogram}
\usage{
plot_p_hist(dep, adjusted = FALSE, wrap = FALSE)
}
\arguments{
\item{dep}{SummarizedExperiment,
Data object for which differentially enriched proteins are annotated
(output from \code{\link{test_diff}()} and \code{\link{add_rejections}()}).}

\item{adjusted}{Logical(1),
Whether or not to use adjusted p values.}

\item{wrap}{Logical(1),
Whether or not to display different histograms for the different contrasts.}
}
\value{
A histogram (generated by \code{\link[ggplot2]{ggplot}}).
}
\description{
\code{plot_p_hist} generates a p value histogram.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
imputed <- impute(norm, fun = "MinProb", q = 0.01)

# Test for differentially expressed proteins
diff <- test_diff(imputed, "control", "Ctrl")
dep <- add_rejections(diff, alpha = 0.05, lfc = 1)

# Plot p value histogram
plot_p_hist(dep)
plot_p_hist(dep, wrap = TRUE)
}
