% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichR_functions.R
\name{plot_gsea}
\alias{plot_gsea}
\title{Plot enriched Gene Sets}
\usage{
plot_gsea(
  gsea_results,
  number = 10,
  alpha = 0.05,
  contrasts = NULL,
  databases = NULL,
  nrow = 1,
  term_size = 8
)
}
\arguments{
\item{gsea_results}{Data.frame,
Gene Set Enrichment Analysis results object.
(output from \code{\link{test_gsea}()}).}

\item{number}{Numeric(1),
Sets the number of enriched terms per contrast to be plotted.}

\item{alpha}{Numeric(1),
Sets the threshold for the adjusted P value.}

\item{contrasts}{Character,
Specifies the contrast(s) to plot.
If 'NULL' all contrasts will be plotted.}

\item{databases}{Character,
Specifies the database(s) to plot.
If 'NULL' all databases will be plotted.}

\item{nrow}{Numeric(1),
Sets the number of rows for the plot.}

\item{term_size}{Numeric(1),
Sets the text size of the terms.}
}
\value{
A barplot of the enriched terms
(generated by \code{\link[ggplot2]{ggplot}}).
}
\description{
\code{plot_gsea} plots enriched gene sets
from Gene Set Enrichment Analysis.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
imputed <- impute(norm, fun = "MinProb", q = 0.01)

# Test for differentially expressed proteins
diff <- diff <- test_diff(imputed, "control", "Ctrl")
dep <- add_rejections(diff, alpha = 0.05, lfc = 1)

\dontrun{

# Test enrichments
gsea_results <- test_gsea(dep)
plot_gsea(gsea_results)

}
}
