% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_QC.R
\name{plot_detect}
\alias{plot_detect}
\title{Visualize intensities of proteins with missing values}
\usage{
plot_detect(se)
}
\arguments{
\item{se}{SummarizedExperiment,
Data object with missing values.}
}
\value{
Density and CumSum plots of intensities of
proteins with and without missing values
(generated by \code{\link[ggplot2]{ggplot}}).
}
\description{
\code{plot_detect} generates density and CumSum plots
of protein intensities with and without missing values
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter
filt <- filter_missval(se, thr = 0)

# Plot intensities of proteins with missing values
plot_detect(filt)
}
