% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{make_unique}
\alias{make_unique}
\title{Make unique names}
\usage{
make_unique(proteins, names, ids, delim = ";")
}
\arguments{
\item{proteins}{Data.frame,
Protein table for which unique names will be created.}

\item{names}{Character(1),
Name of the column containing feature names.}

\item{ids}{Character(1),
Name of the column containing feature IDs.}

\item{delim}{Character(1),
Sets the delimiter separating the feature names within one protein group.}
}
\value{
A data.frame with the additional variables
"name" and "ID" containing unique names and identifiers, respectively.
}
\description{
\code{make_unique} generates unique identifiers
for a proteomics dataset based on "name" and "id" columns.
}
\examples{
# Load example
data <- UbiLength

# Check colnames and pick the appropriate columns
colnames(data)
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")
}
