% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{add_rejections}
\alias{add_rejections}
\title{Mark significant proteins}
\usage{
add_rejections(diff, alpha = 0.05, lfc = 1)
}
\arguments{
\item{diff}{SummarizedExperiment,
Proteomics dataset on which differential enrichment analysis
has been performed (output from \code{\link{test_diff}()}).}

\item{alpha}{Numeric(1),
Sets the threshold for the adjusted P value.}

\item{lfc}{Numeric(1),
Sets the threshold for the log2 fold change.}
}
\value{
A SummarizedExperiment object
annotated with logical columns indicating significant proteins.
}
\description{
\code{add_rejections} marks significant proteins based on defined cutoffs.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
imputed <- impute(norm, fun = "MinProb", q = 0.01)

# Test for differentially expressed proteins
diff <- test_diff(imputed, "control", "Ctrl")
dep <- add_rejections(diff, alpha = 0.05, lfc = 1)
}
