% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateRnaSeqData.R
\name{simulateRnaSeqData}
\alias{simulateRnaSeqData}
\title{Example counts table of RNA-seq data}
\usage{
simulateRnaSeqData(
  output = c("matrix", "RangedSummarizedExperiment"),
  n = 1000,
  m = 6,
  seed = 0L,
  ...
)
}
\arguments{
\item{output}{output type}

\item{n}{number of genes}

\item{m}{number of samples}

\item{seed}{a single integer value specifying the random number generator
seed}

\item{...}{arguments passed to \code{\link[DESeq2]{makeExampleDESeqDataSet}}}
}
\value{
Depending on the \code{output} setting a matrix or an
  \code{\linkS4class{RangedSummarizedExperiment}} object.
}
\description{
Simulated expression data of an RNA-seq experiment.
}
\details{
The count table is generated using the
\code{\link[DESeq2]{makeExampleDESeqDataSet}} method from the \pkg{DESeq2}
package.
}
\examples{
## count data matrix
mx = simulateRnaSeqData()
head(mx)

## return an RangedSummarizedExperiment object
se = simulateRnaSeqData(output = "RangedSummarizedExperiment")
se
}
\seealso{
simulateNormFactors
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2016-2023
}
