% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inOutFiles.R
\name{write.excel}
\alias{write.excel}
\title{This function exports a data.frame to a Excel file.}
\usage{
write.excel(df, tags = NULL, colors = NULL, tabname = "foo", filename = NULL)
}
\arguments{
\item{df}{An data.frame}

\item{tags}{xxx}

\item{colors}{xxx}

\item{tabname}{xxx}

\item{filename}{A character string for the name of the Excel file.}
}
\value{
A Excel file (.xlsx)
}
\description{
This function exports a data.frame to a Excel file.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
df <- Biobase::exprs(Exp1_R25_pept[seq_len(100)])
tags <- GetMetacell(Exp1_R25_pept[seq_len(100)])
colors <- list(
    "Missing POV" = "lightblue",
    "Missing MEC" = "orange",
    "Quant. by recovery" = "lightgrey",
    "Quant. by direct id" = "white",
    "Combined tags" = "red"
)
write.excel(df, tags, colors, filename = "toto")

}
\author{
Samuel Wieczorek
}
