% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesImputation_ProteinLevel.R
\name{reIntroduceMEC}
\alias{reIntroduceMEC}
\title{Put back LAPALA into  a \code{MSnSet} object}
\usage{
reIntroduceMEC(obj, MECIndex)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}

\item{MECIndex}{A data.frame that contains index of MEC (see findMECBlock) .}
}
\value{
The object \code{obj} where LAPALA have been reintroduced
}
\description{
Put back LAPALA into  a \code{MSnSet} object
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(100)]
lapala <- findMECBlock(obj)
obj <- wrapper.impute.detQuant(obj, na.type = c("Missing POV", "Missing MEC"))
obj <- reIntroduceMEC(obj, lapala)

}
\author{
Samuel Wieczorek
}
