% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacell_Plots.R
\name{metacellHisto_HC}
\alias{metacellHisto_HC}
\title{Histogram of missing values}
\usage{
metacellHisto_HC(
  obj,
  pattern = NULL,
  indLegend = "auto",
  showValues = FALSE,
  pal = NULL
)
}
\arguments{
\item{obj}{xxx}

\item{pattern}{xxx}

\item{indLegend}{The indices of the column name's in \code{Biobase::pData()}
tab}

\item{showValues}{A logical that indicates wether numeric values should be
drawn above the bars.}

\item{pal}{xxx}
}
\value{
A histogram
}
\description{
#' This method plots a histogram of missing values. Same as the function
\code{mvHisto} but uses the package \code{highcharter}
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept
pattern <- "Missing POV"
pal <- ExtendPalette(2, "Dark2")
metacellHisto_HC(obj, pattern, showValues = TRUE, pal = pal)

}
\author{
Florence Combes, Samuel Wieczorek
}
