% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesFilter.R
\name{getIndicesOfLinesToRemove}
\alias{getIndicesOfLinesToRemove}
\title{Get the indices of the lines to delete, based on a prefix string}
\usage{
getIndicesOfLinesToRemove(obj, idLine2Delete = NULL, prefix = NULL)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}

\item{idLine2Delete}{The name of the column that correspond to the data
to filter}

\item{prefix}{A character string that is the prefix to find in the data}
}
\value{
A vector of integers.
}
\description{
Get the indices of the lines to delete, based on a prefix string
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
ind <- getIndicesOfLinesToRemove(Exp1_R25_pept[seq_len(100)], 
"Potential_contaminant",
    prefix = "+"
)

}
\author{
Samuel Wieczorek
}
