% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agregation.R
\name{aggregateTopn}
\alias{aggregateTopn}
\title{Compute the intensity of proteins as the sum of the
intensities of their n best peptides.}
\usage{
aggregateTopn(obj.pep, X, method = "Mean", n = 10)
}
\arguments{
\item{obj.pep}{A matrix of intensities of peptides}

\item{X}{An adjacency matrix in which lines and columns correspond
respectively to peptides and proteins.}

\item{method}{xxx}

\item{n}{The maximum number of peptides used to aggregate a protein.}
}
\value{
A matrix of intensities of proteins
}
\description{
This function computes the intensity of proteins as the sum of the
intensities of their n best peptides.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj.pep <- Exp1_R25_pept[seq_len(10)]
protID <- "Protein_group_IDs"
X <- BuildAdjacencyMatrix(obj.pep, protID, FALSE)
ll.agg <- aggregateTopn(obj.pep, X, n = 3)

}
\author{
Alexia Dorffer, Samuel Wieczorek
}
