% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoProcessingStepImplementations.R
\name{getAcquiredCompensationMatrix}
\alias{getAcquiredCompensationMatrix}
\title{extract compensation matrix from a flowCore::flowFrame}
\usage{
getAcquiredCompensationMatrix(ff)
}
\arguments{
\item{ff}{a flowCore::flowFrame}
}
\value{
the found compensation matrix
}
\description{
helper function retrieving the compensation matrix stored
in fcs file (if any). It scans the following keywords: $SPILL, $spillover
and $SPILLOVER
}
\examples{

rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
sampleFiles <-
    file.path(rawDataDir, list.files(rawDataDir, pattern = "Donor"))

truncateMaxRange <- FALSE
minLimit <- NULL

# create flowCore::flowSet with all samples of a dataset
fsRaw <- readSampleFiles(
    sampleFiles = sampleFiles,
    whichSamples = "all",
    truncate_max_range = truncateMaxRange,
    min.limit = minLimit)
compensationMatrix <- getAcquiredCompensationMatrix(fsRaw[[2]])
}
