% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{ScaleTransformApp}
\alias{ScaleTransformApp}
\title{interactive display and modification of scale transform list}
\usage{
ScaleTransformApp(dir = ".")
}
\arguments{
\item{dir}{the root directory into which the engine will look for existing
CytoPipeline experiments}
}
\value{
no return value
}
\description{
this application allows the user to visualize a scale
transformation list, possibly amending it channel after channel,
and save the results on disk.
The needed input tranformation list and flow frame for visualization needs
to be read from a CytoPipeline experiments stored in cache.
}
\examples{

# run CytoPipeline object first

outputDir <- base::tempdir()


rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
experimentName <- "OMIP021_PeacoQC"
sampleFiles <- 
    file.path(rawDataDir, list.files(rawDataDir, pattern = "Donor"))
jsonDir <- system.file("extdata", package = "CytoPipeline")
jsonPath <- file.path(jsonDir, "pipelineParams.json")

pipL2 <- 
    CytoPipeline(
        jsonPath,
        experimentName = experimentName,
        sampleFiles = sampleFiles)

suppressWarnings(execute(
    pipL2,
    rmCache = TRUE,
    path = outputDir))

# run shiny app

if (interactive())
    ScaleTransformApp(dir = outputDir)                     

}
