% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytobank2GatingSet.R, R/cytobankExperiment.R
\name{cytobank_to_gatingset}
\alias{cytobank_to_gatingset}
\alias{cytobank_to_gatingset.default}
\alias{cytobank2GatingSet}
\alias{cytobank_to_gatingset.cytobank_experiment}
\title{A wrapper that parses the gatingML and FCS files (or \code{cytobank_experiment} object) into GatingSet}
\usage{
\method{cytobank_to_gatingset}{default}(x, FCS, trans = NULL, ...)

\method{cytobank_to_gatingset}{cytobank_experiment}(x, panel_id = 1, ...)
}
\arguments{
\item{x}{the cytobank_experiment object or the full path of gatingML file}

\item{FCS}{FCS files to be loaded}

\item{trans}{a 'transfomerList' object to override the transformations from gatingML files.
it is typically used by 'cytobank_experiment' parser(i.e. 'cytobank_to_gatingset.cytobank_experiment')  to use the scales info recorded in yaml file.}

\item{...}{other arguments}

\item{panel_id}{select panel to process}
}
\value{
a GatingSet
}
\description{
A wrapper that parses the gatingML and FCS files (or \code{cytobank_experiment} object) into GatingSet
}
\examples{
\dontrun{
acsfile <- system.file("extdata/cytobank_experiment.acs", package = "CytoML")
ce <- open_cytobank_experiment(acsfile)
xmlfile <- ce$gatingML
fcsFiles <- list.files(ce$fcsdir, full.names = TRUE)
gs <<- cytobank_to_gatingset(xmlfile, fcsFiles)
library(ggcyto)
autoplot(gs[[1]])
}
}
