% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation_nb_parameters_optimized.R
\name{function_create_mock_dataset_withmarkerinfo}
\alias{function_create_mock_dataset_withmarkerinfo}
\title{Compute simulated cell values for one simulation with markers NB information.}
\usage{
function_create_mock_dataset_withmarkerinfo(variation)
}
\arguments{
\item{variation}{list, list of data.frames containing the different variable
input paramaters to generate the data:
    - marker_name: name of the marker (character);
    - nb_donor: number of donors;
    - rho: fold change;
    - subject_effect: standard deviation for the normal distribution from
    which the donor's means will be drawn;
    - mu0: mean of the negative binomial for the gamma distribution from
    which the means of the different donor will be drawn;
    - dispersion: dispersion of the negative binomial from
    which the DE marker's cell values will be drawn;
    - nb_cell_per_sample: number of cells per sample.}
}
\value{
list with 4 slots:
    - df_info: data.frame of experimental information;
    - DEmarkers_names: vector of DE marker names;
    - raw_data: data.frame of raw cell values;
    - data: data.frame of transformed cell values.
}
\description{
Compute simulated cell values for one simulation with markers NB information.
}
\details{
Function to compute the simulated cell values using a combination of
variable parameters, when we have prior information about the markers
distribution parameters (mean and dispersion of the negative binomial).
}
\keyword{internal}
