\name{draw.heatmap}
\alias{draw.heatmap}
\alias{draw.heatmap,matrix-method}
\alias{draw.heatmap,list-method}
\title{Draw a coverage heatmap}
\description{This method draws a heatmap of the coverage values using the matrix that is passed as an argument to the method}
\usage{
  \S4method{draw.heatmap}{matrix}(data,outfile, color,...)
  \S4method{draw.heatmap}{list}(data,outfile, color,...)
}
\arguments{
  \item{data}{Matrix or list of matrices generated by the function \code{cov.matrix}}
  \item{outfile}{URL of the \code{.png} file where the plot will be created}
  \item{color}{Graphical argument to set the color of the plot}
  \item{\dots}{Additional parameters}
}
\details{
  This function is used to create a coverage heatmap of the matrix/list of matrices generated using the \code{cov.matrix} function
}
\author{
  Ernesto Lowy <ernestolowy@gmail.com>
}
\seealso{
  \code{\link{cov.matrix}}
}
\examples{
  ## draw the heatmap for a coverate matrix that was previously calculated 
  # using the cov.matrix function for a BAM file containing ChIP-seq data 
  # from a H3K36me3 histone modification experiment
  data(DF_H3K36me3)
  draw.heatmap(DF_H3K36me3,outfile="testHeatmap.png")
  
  ## Now, draw two heatmaps for 2 different coverage matrices previously 
  # obtained for the same H3K36me3 histone modification experiment and its
  # respective 'control' file
  data(DF_H3K36me3_control)
  
  # create a list with the two matrices
  input_l=list(DF_H3K36me3,DF_H3K36me3_control)
  draw.heatmap(input_l,outfile="testHeatmap.png")
}
