% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongTable-utils.R
\name{subset,LongTable-method}
\alias{subset,LongTable-method}
\title{Subset method for a LongTable object.}
\usage{
\S4method{subset}{LongTable}(x, i, j, assays = assayNames(x), reindex = TRUE)
}
\arguments{
\item{x}{\code{LongTable} The object to subset.}

\item{i}{\code{character}, \code{numeric}, \code{logical} or \code{call}
Character: pass in a character vector of rownames for the \code{LongTable} object
or a valid regex query which will be evaluated against the rownames.
Numeric or Logical: vector of indices or a logical vector to subset
the rows of a \code{LongTable}.
Call: Accepts valid query statements to the \code{data.table} i parameter,
this can be used to make complex queries using the \code{data.table} API
for the \code{rowData} data.table.}

\item{j}{\code{character}, \code{numeric}, \code{logical} or \code{call}
Character: pass in a character vector of colnames for the \code{LongTable} object
or a valid regex query which will be evaluated against the colnames.
Numeric or Logical: vector of indices or a logical vector to subset
the columns of a \code{LongTable}.
Call: Accepts valid query statements to the \code{data.table} i parameter,
this can be used to make complex queries using the \code{data.table} API
for the \code{colData} data.table.}

\item{assays}{\code{character}, \code{numeric} or \code{logical} Optional list of assay
names to subset. Can be used to subset the assays list further,
returning only the selected items in the new LongTable.}

\item{reindex}{\code{logical(1)} Should index values be reset such that they
are the smallest possible set of consecutive integers. Modifies the
"rowKey", "colKey", and all assayKey columns. Initial benchmarks indicate
\code{reindex=FALSE} saves ~20\% of both execution time and memory allocation. The
cost of reindexing decreases the smaller your subset gets.}
}
\value{
\code{LongTable} A new \code{LongTable} object subset based on the specified
parameters.
}
\description{
Allows use of the colData and rowData \code{data.table} objects to query based on
rowID and colID, which is then used to subset all assay \code{data.table}s stored
in the \code{assays} slot.
This function is endomorphic, it always returns a LongTable object.
}
\examples{
# Character
subset(merckLongTable, 'ABT-888', 'CAOV3')
# Numeric
subset(merckLongTable, 1, c(1, 2))
# Logical
subset(merckLongTable, , colData(merckLongTable)$sampleid == 'A2058')
# Call
subset(merckLongTable, drug1id == 'Dasatinib' & drug2id != '5-FU',
    sampleid == 'A2058')

}
