% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-optimization.R
\name{make_optim_function}
\alias{make_optim_function}
\title{Takes a non-primitive R function and refactors it to be compatible with
optimization via \code{stats::optim}.}
\usage{
make_optim_function(fn, ...)
}
\arguments{
\item{fn}{\code{function} A non-primitive function}

\item{...}{Arguments to \code{fn} to fix for before building the
function to be optimized. Useful for reducing the number of free parameters
in an optimization if there are insufficient degrees of freedom.}
}
\description{
Takes a non-primitive R function and refactors it to be compatible with optimization via \code{stats::optim}.
}
\seealso{
\code{\link{drop_fn_params}}, \code{\link{collect_fn_params}}
}
