% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TREDataMapper-class.R
\name{TREDataMapper}
\alias{TREDataMapper}
\title{Constructor for the \code{TREDataMapper} class, which maps from one or
more raw experimental data files to the slots of a \code{LongTable} object.}
\usage{
TREDataMapper(
  rawdata = data.frame(),
  rowDataMap = list(character(), character()),
  colDataMap = list(character(), character()),
  assayMap = list(list(character(), character())),
  metadataMap = list(character())
)
}
\arguments{
\item{rawdata}{A \code{data.frame} of raw data from a treatment response
experiment. This will be coerced to a \code{data.table} internally. We recommend
using joins to aggregate your raw data if it is not present in a single file.}

\item{rowDataMap}{A list-like object containing two \code{character} vectors.
The first is column names in \code{rawdata} needed to uniquely identify each row,
the second is additional columns which map to rows, but are not required to
uniquely identify them. Rows should be treatments.}

\item{colDataMap}{A list-like object containing two \code{character} vectors.
The first is column names in \code{rawdata} needed to uniquely identify each
column, the second is additional columns which map to rows, but are not
required to uniquely identify them. Columns should be samples.}

\item{assayMap}{A list-like where each item is a \code{list} with two \code{character}
vectors defining an assay, the first containing the identifier columns in
\code{rawdata} needed to uniquely identify each row an assay, and the second the
\code{rawdata} columns to be mapped to that assay. The names of \code{assayMap}
will be the names of the assays in the \code{TreatmentResponseExperiment} that
is created when calling \code{metaConstruct} on this \code{DataMapper} object. If the
character vectors have names, the value columns will be renamed accordingly.}

\item{metadataMap}{A list-like where each item is a \code{character} vector of
\code{rawdata} column names to assign to the \verb{@metadata} of the \code{LongTable},
where the name of that assay is the name of the list item. If names are
omitted, assays will be numbered by their index in the list.}
}
\value{
A \code{TREDataMapper} object, with columns mapped to it's slots according
to the various maps in the \code{LongTableDataMapper} object.
}
\description{
Constructor for the \code{TREDataMapper} class, which maps from one or
more raw experimental data files to the slots of a \code{LongTable} object.
}
\details{
The \code{guessMapping} method can be used to test hypotheses about the
cardinality of one or more sets of identifier columns. This is helpful
to determine the id columns for \code{rowDataMap} and \code{colDataMap}, as well
as identify columns mapping to \code{assays} or \code{metadata}.

To attach metadata not associated with \code{rawdata}, please use the \code{metadata}
assignment method on your \code{TREDataMapper}. This metadata will be
merge with any metadata from \code{metadataMap} and added to the \code{LongTable}
which this object ultimately constructs.
}
\seealso{
\code{\link{guessMapping}}
}
