% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongTable-class.R
\name{LongTable}
\alias{LongTable}
\title{LongTable constructor method}
\usage{
LongTable(
  rowData,
  rowIDs,
  colData,
  colIDs,
  assays,
  assayIDs,
  metadata = list(),
  keep.rownames = FALSE
)
}
\arguments{
\item{rowData}{\code{data.frame} A rectangular object coercible to a \code{data.table}.}

\item{rowIDs}{\code{character} A vector of \code{rowData} column names needed to
uniquely identify each row in a \code{LongTable}.}

\item{colData}{\code{data.frame} A rectangular object coercible to a \code{data.table.}}

\item{colIDs}{\code{chacter} A vector of \code{colData} column names needed to uniquely
identify each column in a \code{LongTable}.}

\item{assays}{\code{list} A list of rectangular objects, each coercible to
a \code{data.table}. Must be named and item names must match the \code{assayIDs}
list.}

\item{assayIDs}{\code{list} A list of \code{character} vectors specifying the columns
needed to uniquely identify each row in an \code{assay}. Names must match the
\code{assays} list.}

\item{metadata}{\code{list} A list of one or more metadata items associated with
a LongTable experiment.}

\item{keep.rownames}{\code{logical(1)} or \code{character(1)} Should rownames be
retained when coercing to \code{data.table} inside the constructor. Default
is FALSE. If TRUE, adds a 'rn' column to each rectangular object that
gets coerced from \code{data.frame} to \code{data.table}. If a string, that becomes
the name of the rownames column.}
}
\value{
A \code{LongTable} object containing the data for a treatment response
experiment and configured according to the rowIDs and colIDs arguments.
}
\description{
LongTable constructor method
}
\examples{
"See vignette('The LongTable Class', package='CoreGx')"

}
